/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config;

import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.impl.config.BaseConfigSource;
import org.apache.deltaspike.core.util.PropertyFileUtils;

public class PropertyFileConfigSource
extends BaseConfigSource {
    public static final String RELOAD_PERIOD = "deltaspike_reload";
    public static final int RELOAD_PERIOD_DEFAULT = 300;
    private final ConfigResolver.ConfigHelper configHelper;
    private Map<String, String> properties;
    private final URL propertyFileUrl;
    private String filePath;
    private int reloadAllSeconds = 300;
    private Instant fileLastModified = null;
    private int reloadAfterSec;
    private Consumer<Set<String>> reportAttributeChange;

    public PropertyFileConfigSource(URL propertyFileUrl) {
        this.propertyFileUrl = propertyFileUrl;
        this.filePath = propertyFileUrl.toExternalForm();
        this.properties = this.toMap(PropertyFileUtils.loadProperties((URL)propertyFileUrl));
        if (this.isFile(propertyFileUrl)) {
            this.calculateReloadTime();
            if (this.reloadAllSeconds < 0) {
                this.configHelper = null;
            } else {
                this.fileLastModified = this.getLastModified();
                this.configHelper = ConfigResolver.getConfigProvider().getHelper();
                this.reloadAfterSec = this.getNowSeconds() + this.reloadAllSeconds;
            }
        } else {
            this.configHelper = null;
        }
        this.initOrdinal(100);
    }

    private void calculateReloadTime() {
        String reloadPeriod = this.properties.get(RELOAD_PERIOD);
        if (reloadPeriod != null) {
            try {
                int reload = Integer.parseInt(reloadPeriod);
                if (reload < 0) {
                    this.fileLastModified = null;
                    this.log.info("Disable dynamic reloading for ConfigSource " + this.filePath);
                } else {
                    this.reloadAllSeconds = reload;
                }
            }
            catch (NumberFormatException nfe) {
                this.log.warning("Wrong value for deltaspike_reload property: " + reloadPeriod + ". Must be numeric in seconds. Using default 300");
                this.reloadAllSeconds = 300;
            }
        }
    }

    protected Map<String, String> toMap(Properties properties) {
        HashMap<String, String> result = new HashMap<String, String>(properties.size());
        for (String propertyName : properties.stringPropertyNames()) {
            result.put(propertyName, properties.getProperty(propertyName));
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<String, String> getProperties() {
        if (this.needsReload()) {
            this.reloadProperties();
        }
        return this.properties;
    }

    public String getPropertyValue(String key) {
        if (this.needsReload()) {
            this.reloadProperties();
        }
        return this.properties.get(key);
    }

    private boolean needsReload() {
        Instant newLastModified;
        return this.fileLastModified != null && this.getNowSeconds() > this.reloadAfterSec && (newLastModified = this.getLastModified()) != null && newLastModified.isAfter(this.fileLastModified);
    }

    private synchronized void reloadProperties() {
        if (this.needsReload()) {
            Map<String, String> newProps = this.toMap(PropertyFileUtils.loadProperties((URL)this.propertyFileUrl));
            Set modfiedAttributes = this.configHelper.diffConfig(this.properties, newProps);
            if (!modfiedAttributes.isEmpty()) {
                this.reportAttributeChange.accept(modfiedAttributes);
            }
            this.properties = newProps;
            this.fileLastModified = this.getLastModified();
            this.calculateReloadTime();
            this.reloadAfterSec = this.getNowSeconds() + this.reloadAllSeconds;
        }
    }

    private int getNowSeconds() {
        return (int)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime());
    }

    private Instant getLastModified() {
        try {
            return Files.getLastModifiedTime(Paths.get(this.propertyFileUrl.toURI()), new LinkOption[0]).toInstant();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Cannot dynamically reload property file {0}. Not able to read last modified date", this.filePath);
            return null;
        }
    }

    private boolean isFile(URL propertyFileUrl) {
        return "file".equalsIgnoreCase(propertyFileUrl.getProtocol());
    }

    public String getConfigName() {
        return this.filePath;
    }

    public void setOnAttributeChange(Consumer<Set<String>> reportAttributeChange) {
        this.reportAttributeChange = reportAttributeChange;
    }

    public boolean isScannable() {
        return true;
    }
}

