/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.xss.impl;

import org.owasp.esapi.Encoder;
import org.owasp.esapi.StringUtilities;
import org.owasp.esapi.errors.ValidationException;
import org.owasp.esapi.reference.validation.BaseValidationRule;

class LongValidationRule
extends BaseValidationRule {
    private final long minValue;
    private final long maxValue;

    LongValidationRule(String typeName, Encoder encoder, long minValue, long maxValue) {
        super(typeName, encoder);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public Long getValid(String context, String input) throws ValidationException {
        return this.safelyParse(context, input);
    }

    private Long safelyParse(String context, String input) throws ValidationException {
        if (input != null) {
            input = input.trim();
        }
        if (StringUtilities.isEmpty(input)) {
            if (this.allowNull) {
                return null;
            }
            throw new ValidationException(context + ": Input number required", "Input number required: context=" + context + ", input=" + input, context);
        }
        String canonical = this.encoder.canonicalize(input);
        if (this.minValue > this.maxValue) {
            throw new ValidationException(context + ": Invalid number input: context", "Validation parameter error for number: maxValue ( " + this.maxValue + ") must be greater than minValue ( " + this.minValue + ") for " + context, context);
        }
        try {
            long i = Long.parseLong(canonical);
            if (i < this.minValue) {
                throw new ValidationException("Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context, "Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context + ", input=" + input, context);
            }
            if (i > this.maxValue) {
                throw new ValidationException("Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context, "Invalid number input must be between " + this.minValue + " and " + this.maxValue + ": context=" + context + ", input=" + input, context);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new ValidationException(context + ": Invalid number input", "Invalid number input format: context=" + context + ", input=" + input, e, context);
        }
    }

    @Override
    public Long sanitize(String context, String input) {
        Long toReturn = 0L;
        try {
            toReturn = this.safelyParse(context, input);
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return toReturn;
    }
}

