// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: spark/connect/common.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// StorageLevel for persisting Datasets/Tables.
struct Spark_Connect_StorageLevel: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Whether the cache should use disk or not.
  var useDisk: Bool = false

  /// (Required) Whether the cache should use memory or not.
  var useMemory: Bool = false

  /// (Required) Whether the cache should use off-heap or not.
  var useOffHeap: Bool = false

  /// (Required) Whether the cached data is deserialized or not.
  var deserialized: Bool = false

  /// (Required) The number of replicas.
  var replication: Int32 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// ResourceInformation to hold information about a type of Resource.
/// The corresponding class is 'org.apache.spark.resource.ResourceInformation'
struct Spark_Connect_ResourceInformation: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) The name of the resource
  var name: String = String()

  /// (Required) An array of strings describing the addresses of the resource.
  var addresses: [String] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

/// An executor resource request.
struct Spark_Connect_ExecutorResourceRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) resource name.
  var resourceName: String = String()

  /// (Required) resource amount requesting.
  var amount: Int64 = 0

  /// Optional script used to discover the resources.
  var discoveryScript: String {
    get {return _discoveryScript ?? String()}
    set {_discoveryScript = newValue}
  }
  /// Returns true if `discoveryScript` has been explicitly set.
  var hasDiscoveryScript: Bool {return self._discoveryScript != nil}
  /// Clears the value of `discoveryScript`. Subsequent reads from it will return its default value.
  mutating func clearDiscoveryScript() {self._discoveryScript = nil}

  /// Optional vendor, required for some cluster managers.
  var vendor: String {
    get {return _vendor ?? String()}
    set {_vendor = newValue}
  }
  /// Returns true if `vendor` has been explicitly set.
  var hasVendor: Bool {return self._vendor != nil}
  /// Clears the value of `vendor`. Subsequent reads from it will return its default value.
  mutating func clearVendor() {self._vendor = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _discoveryScript: String? = nil
  fileprivate var _vendor: String? = nil
}

/// A task resource request.
struct Spark_Connect_TaskResourceRequest: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) resource name.
  var resourceName: String = String()

  /// (Required) resource amount requesting as a double to support fractional
  /// resource requests.
  var amount: Double = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_ResourceProfile: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Optional) Resource requests for executors. Mapped from the resource name
  /// (e.g., cores, memory, CPU) to its specific request.
  var executorResources: Dictionary<String,Spark_Connect_ExecutorResourceRequest> = [:]

  /// (Optional) Resource requests for tasks. Mapped from the resource name
  /// (e.g., cores, memory, CPU) to its specific request.
  var taskResources: Dictionary<String,Spark_Connect_TaskResourceRequest> = [:]

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_Origin: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Indicate the origin type.
  var function: Spark_Connect_Origin.OneOf_Function? = nil

  var pythonOrigin: Spark_Connect_PythonOrigin {
    get {
      if case .pythonOrigin(let v)? = function {return v}
      return Spark_Connect_PythonOrigin()
    }
    set {function = .pythonOrigin(newValue)}
  }

  var jvmOrigin: Spark_Connect_JvmOrigin {
    get {
      if case .jvmOrigin(let v)? = function {return v}
      return Spark_Connect_JvmOrigin()
    }
    set {function = .jvmOrigin(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  /// (Required) Indicate the origin type.
  enum OneOf_Function: Equatable, Sendable {
    case pythonOrigin(Spark_Connect_PythonOrigin)
    case jvmOrigin(Spark_Connect_JvmOrigin)

  }

  init() {}
}

struct Spark_Connect_PythonOrigin: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Required) Name of the origin, for example, the name of the function
  var fragment: String = String()

  /// (Required) Callsite to show to end users, for example, stacktrace.
  var callSite: String = String()

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_JvmOrigin: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Optional) Line number in the source file.
  var line: Int32 {
    get {return _line ?? 0}
    set {_line = newValue}
  }
  /// Returns true if `line` has been explicitly set.
  var hasLine: Bool {return self._line != nil}
  /// Clears the value of `line`. Subsequent reads from it will return its default value.
  mutating func clearLine() {self._line = nil}

  /// (Optional) Start position in the source file.
  var startPosition: Int32 {
    get {return _startPosition ?? 0}
    set {_startPosition = newValue}
  }
  /// Returns true if `startPosition` has been explicitly set.
  var hasStartPosition: Bool {return self._startPosition != nil}
  /// Clears the value of `startPosition`. Subsequent reads from it will return its default value.
  mutating func clearStartPosition() {self._startPosition = nil}

  /// (Optional) Start index in the source file.
  var startIndex: Int32 {
    get {return _startIndex ?? 0}
    set {_startIndex = newValue}
  }
  /// Returns true if `startIndex` has been explicitly set.
  var hasStartIndex: Bool {return self._startIndex != nil}
  /// Clears the value of `startIndex`. Subsequent reads from it will return its default value.
  mutating func clearStartIndex() {self._startIndex = nil}

  /// (Optional) Stop index in the source file.
  var stopIndex: Int32 {
    get {return _stopIndex ?? 0}
    set {_stopIndex = newValue}
  }
  /// Returns true if `stopIndex` has been explicitly set.
  var hasStopIndex: Bool {return self._stopIndex != nil}
  /// Clears the value of `stopIndex`. Subsequent reads from it will return its default value.
  mutating func clearStopIndex() {self._stopIndex = nil}

  /// (Optional) SQL text.
  var sqlText: String {
    get {return _sqlText ?? String()}
    set {_sqlText = newValue}
  }
  /// Returns true if `sqlText` has been explicitly set.
  var hasSqlText: Bool {return self._sqlText != nil}
  /// Clears the value of `sqlText`. Subsequent reads from it will return its default value.
  mutating func clearSqlText() {self._sqlText = nil}

  /// (Optional) Object type.
  var objectType: String {
    get {return _objectType ?? String()}
    set {_objectType = newValue}
  }
  /// Returns true if `objectType` has been explicitly set.
  var hasObjectType: Bool {return self._objectType != nil}
  /// Clears the value of `objectType`. Subsequent reads from it will return its default value.
  mutating func clearObjectType() {self._objectType = nil}

  /// (Optional) Object name.
  var objectName: String {
    get {return _objectName ?? String()}
    set {_objectName = newValue}
  }
  /// Returns true if `objectName` has been explicitly set.
  var hasObjectName: Bool {return self._objectName != nil}
  /// Clears the value of `objectName`. Subsequent reads from it will return its default value.
  mutating func clearObjectName() {self._objectName = nil}

  /// (Optional) Stack trace.
  var stackTrace: [Spark_Connect_StackTraceElement] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _line: Int32? = nil
  fileprivate var _startPosition: Int32? = nil
  fileprivate var _startIndex: Int32? = nil
  fileprivate var _stopIndex: Int32? = nil
  fileprivate var _sqlText: String? = nil
  fileprivate var _objectType: String? = nil
  fileprivate var _objectName: String? = nil
}

/// A message to hold a [[java.lang.StackTraceElement]].
struct Spark_Connect_StackTraceElement: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// (Optional) Class loader name
  var classLoaderName: String {
    get {return _classLoaderName ?? String()}
    set {_classLoaderName = newValue}
  }
  /// Returns true if `classLoaderName` has been explicitly set.
  var hasClassLoaderName: Bool {return self._classLoaderName != nil}
  /// Clears the value of `classLoaderName`. Subsequent reads from it will return its default value.
  mutating func clearClassLoaderName() {self._classLoaderName = nil}

  /// (Optional) Module name
  var moduleName: String {
    get {return _moduleName ?? String()}
    set {_moduleName = newValue}
  }
  /// Returns true if `moduleName` has been explicitly set.
  var hasModuleName: Bool {return self._moduleName != nil}
  /// Clears the value of `moduleName`. Subsequent reads from it will return its default value.
  mutating func clearModuleName() {self._moduleName = nil}

  /// (Optional) Module version
  var moduleVersion: String {
    get {return _moduleVersion ?? String()}
    set {_moduleVersion = newValue}
  }
  /// Returns true if `moduleVersion` has been explicitly set.
  var hasModuleVersion: Bool {return self._moduleVersion != nil}
  /// Clears the value of `moduleVersion`. Subsequent reads from it will return its default value.
  mutating func clearModuleVersion() {self._moduleVersion = nil}

  /// (Required) Declaring class
  var declaringClass: String = String()

  /// (Required) Method name
  var methodName: String = String()

  /// (Optional) File name
  var fileName: String {
    get {return _fileName ?? String()}
    set {_fileName = newValue}
  }
  /// Returns true if `fileName` has been explicitly set.
  var hasFileName: Bool {return self._fileName != nil}
  /// Clears the value of `fileName`. Subsequent reads from it will return its default value.
  mutating func clearFileName() {self._fileName = nil}

  /// (Required) Line number
  var lineNumber: Int32 = 0

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _classLoaderName: String? = nil
  fileprivate var _moduleName: String? = nil
  fileprivate var _moduleVersion: String? = nil
  fileprivate var _fileName: String? = nil
}

struct Spark_Connect_Bools: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var values: [Bool] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_Ints: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var values: [Int32] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_Longs: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var values: [Int64] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_Floats: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var values: [Float] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_Doubles: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var values: [Double] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

struct Spark_Connect_Strings: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var values: [String] = []

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "spark.connect"

extension Spark_Connect_StorageLevel: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StorageLevel"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "use_disk"),
    2: .standard(proto: "use_memory"),
    3: .standard(proto: "use_off_heap"),
    4: .same(proto: "deserialized"),
    5: .same(proto: "replication"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularBoolField(value: &self.useDisk) }()
      case 2: try { try decoder.decodeSingularBoolField(value: &self.useMemory) }()
      case 3: try { try decoder.decodeSingularBoolField(value: &self.useOffHeap) }()
      case 4: try { try decoder.decodeSingularBoolField(value: &self.deserialized) }()
      case 5: try { try decoder.decodeSingularInt32Field(value: &self.replication) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if self.useDisk != false {
      try visitor.visitSingularBoolField(value: self.useDisk, fieldNumber: 1)
    }
    if self.useMemory != false {
      try visitor.visitSingularBoolField(value: self.useMemory, fieldNumber: 2)
    }
    if self.useOffHeap != false {
      try visitor.visitSingularBoolField(value: self.useOffHeap, fieldNumber: 3)
    }
    if self.deserialized != false {
      try visitor.visitSingularBoolField(value: self.deserialized, fieldNumber: 4)
    }
    if self.replication != 0 {
      try visitor.visitSingularInt32Field(value: self.replication, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StorageLevel, rhs: Spark_Connect_StorageLevel) -> Bool {
    if lhs.useDisk != rhs.useDisk {return false}
    if lhs.useMemory != rhs.useMemory {return false}
    if lhs.useOffHeap != rhs.useOffHeap {return false}
    if lhs.deserialized != rhs.deserialized {return false}
    if lhs.replication != rhs.replication {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ResourceInformation: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ResourceInformation"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "name"),
    2: .same(proto: "addresses"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.name) }()
      case 2: try { try decoder.decodeRepeatedStringField(value: &self.addresses) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.name.isEmpty {
      try visitor.visitSingularStringField(value: self.name, fieldNumber: 1)
    }
    if !self.addresses.isEmpty {
      try visitor.visitRepeatedStringField(value: self.addresses, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ResourceInformation, rhs: Spark_Connect_ResourceInformation) -> Bool {
    if lhs.name != rhs.name {return false}
    if lhs.addresses != rhs.addresses {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ExecutorResourceRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ExecutorResourceRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "resource_name"),
    2: .same(proto: "amount"),
    3: .standard(proto: "discovery_script"),
    4: .same(proto: "vendor"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.resourceName) }()
      case 2: try { try decoder.decodeSingularInt64Field(value: &self.amount) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._discoveryScript) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._vendor) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    if !self.resourceName.isEmpty {
      try visitor.visitSingularStringField(value: self.resourceName, fieldNumber: 1)
    }
    if self.amount != 0 {
      try visitor.visitSingularInt64Field(value: self.amount, fieldNumber: 2)
    }
    try { if let v = self._discoveryScript {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._vendor {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ExecutorResourceRequest, rhs: Spark_Connect_ExecutorResourceRequest) -> Bool {
    if lhs.resourceName != rhs.resourceName {return false}
    if lhs.amount != rhs.amount {return false}
    if lhs._discoveryScript != rhs._discoveryScript {return false}
    if lhs._vendor != rhs._vendor {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_TaskResourceRequest: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".TaskResourceRequest"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "resource_name"),
    2: .same(proto: "amount"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.resourceName) }()
      case 2: try { try decoder.decodeSingularDoubleField(value: &self.amount) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.resourceName.isEmpty {
      try visitor.visitSingularStringField(value: self.resourceName, fieldNumber: 1)
    }
    if self.amount.bitPattern != 0 {
      try visitor.visitSingularDoubleField(value: self.amount, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_TaskResourceRequest, rhs: Spark_Connect_TaskResourceRequest) -> Bool {
    if lhs.resourceName != rhs.resourceName {return false}
    if lhs.amount != rhs.amount {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_ResourceProfile: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".ResourceProfile"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "executor_resources"),
    2: .standard(proto: "task_resources"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_ExecutorResourceRequest>.self, value: &self.executorResources) }()
      case 2: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_TaskResourceRequest>.self, value: &self.taskResources) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.executorResources.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_ExecutorResourceRequest>.self, value: self.executorResources, fieldNumber: 1)
    }
    if !self.taskResources.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMessageMap<SwiftProtobuf.ProtobufString,Spark_Connect_TaskResourceRequest>.self, value: self.taskResources, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_ResourceProfile, rhs: Spark_Connect_ResourceProfile) -> Bool {
    if lhs.executorResources != rhs.executorResources {return false}
    if lhs.taskResources != rhs.taskResources {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Origin: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Origin"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "python_origin"),
    2: .standard(proto: "jvm_origin"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_PythonOrigin?
        var hadOneofValue = false
        if let current = self.function {
          hadOneofValue = true
          if case .pythonOrigin(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.function = .pythonOrigin(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_JvmOrigin?
        var hadOneofValue = false
        if let current = self.function {
          hadOneofValue = true
          if case .jvmOrigin(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.function = .jvmOrigin(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.function {
    case .pythonOrigin?: try {
      guard case .pythonOrigin(let v)? = self.function else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .jvmOrigin?: try {
      guard case .jvmOrigin(let v)? = self.function else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Origin, rhs: Spark_Connect_Origin) -> Bool {
    if lhs.function != rhs.function {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PythonOrigin: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PythonOrigin"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "fragment"),
    2: .standard(proto: "call_site"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self.fragment) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self.callSite) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.fragment.isEmpty {
      try visitor.visitSingularStringField(value: self.fragment, fieldNumber: 1)
    }
    if !self.callSite.isEmpty {
      try visitor.visitSingularStringField(value: self.callSite, fieldNumber: 2)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PythonOrigin, rhs: Spark_Connect_PythonOrigin) -> Bool {
    if lhs.fragment != rhs.fragment {return false}
    if lhs.callSite != rhs.callSite {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_JvmOrigin: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".JvmOrigin"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "line"),
    2: .standard(proto: "start_position"),
    3: .standard(proto: "start_index"),
    4: .standard(proto: "stop_index"),
    5: .standard(proto: "sql_text"),
    6: .standard(proto: "object_type"),
    7: .standard(proto: "object_name"),
    8: .standard(proto: "stack_trace"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularInt32Field(value: &self._line) }()
      case 2: try { try decoder.decodeSingularInt32Field(value: &self._startPosition) }()
      case 3: try { try decoder.decodeSingularInt32Field(value: &self._startIndex) }()
      case 4: try { try decoder.decodeSingularInt32Field(value: &self._stopIndex) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self._sqlText) }()
      case 6: try { try decoder.decodeSingularStringField(value: &self._objectType) }()
      case 7: try { try decoder.decodeSingularStringField(value: &self._objectName) }()
      case 8: try { try decoder.decodeRepeatedMessageField(value: &self.stackTrace) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._line {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._startPosition {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._startIndex {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._stopIndex {
      try visitor.visitSingularInt32Field(value: v, fieldNumber: 4)
    } }()
    try { if let v = self._sqlText {
      try visitor.visitSingularStringField(value: v, fieldNumber: 5)
    } }()
    try { if let v = self._objectType {
      try visitor.visitSingularStringField(value: v, fieldNumber: 6)
    } }()
    try { if let v = self._objectName {
      try visitor.visitSingularStringField(value: v, fieldNumber: 7)
    } }()
    if !self.stackTrace.isEmpty {
      try visitor.visitRepeatedMessageField(value: self.stackTrace, fieldNumber: 8)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_JvmOrigin, rhs: Spark_Connect_JvmOrigin) -> Bool {
    if lhs._line != rhs._line {return false}
    if lhs._startPosition != rhs._startPosition {return false}
    if lhs._startIndex != rhs._startIndex {return false}
    if lhs._stopIndex != rhs._stopIndex {return false}
    if lhs._sqlText != rhs._sqlText {return false}
    if lhs._objectType != rhs._objectType {return false}
    if lhs._objectName != rhs._objectName {return false}
    if lhs.stackTrace != rhs.stackTrace {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_StackTraceElement: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".StackTraceElement"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "class_loader_name"),
    2: .standard(proto: "module_name"),
    3: .standard(proto: "module_version"),
    4: .standard(proto: "declaring_class"),
    5: .standard(proto: "method_name"),
    6: .standard(proto: "file_name"),
    7: .standard(proto: "line_number"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._classLoaderName) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._moduleName) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._moduleVersion) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self.declaringClass) }()
      case 5: try { try decoder.decodeSingularStringField(value: &self.methodName) }()
      case 6: try { try decoder.decodeSingularStringField(value: &self._fileName) }()
      case 7: try { try decoder.decodeSingularInt32Field(value: &self.lineNumber) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._classLoaderName {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._moduleName {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._moduleVersion {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    if !self.declaringClass.isEmpty {
      try visitor.visitSingularStringField(value: self.declaringClass, fieldNumber: 4)
    }
    if !self.methodName.isEmpty {
      try visitor.visitSingularStringField(value: self.methodName, fieldNumber: 5)
    }
    try { if let v = self._fileName {
      try visitor.visitSingularStringField(value: v, fieldNumber: 6)
    } }()
    if self.lineNumber != 0 {
      try visitor.visitSingularInt32Field(value: self.lineNumber, fieldNumber: 7)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_StackTraceElement, rhs: Spark_Connect_StackTraceElement) -> Bool {
    if lhs._classLoaderName != rhs._classLoaderName {return false}
    if lhs._moduleName != rhs._moduleName {return false}
    if lhs._moduleVersion != rhs._moduleVersion {return false}
    if lhs.declaringClass != rhs.declaringClass {return false}
    if lhs.methodName != rhs.methodName {return false}
    if lhs._fileName != rhs._fileName {return false}
    if lhs.lineNumber != rhs.lineNumber {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Bools: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Bools"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedBoolField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedBoolField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Bools, rhs: Spark_Connect_Bools) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Ints: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Ints"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt32Field(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedInt32Field(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Ints, rhs: Spark_Connect_Ints) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Longs: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Longs"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedInt64Field(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedInt64Field(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Longs, rhs: Spark_Connect_Longs) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Floats: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Floats"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedFloatField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedFloatField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Floats, rhs: Spark_Connect_Floats) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Doubles: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Doubles"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedDoubleField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitPackedDoubleField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Doubles, rhs: Spark_Connect_Doubles) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_Strings: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".Strings"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "values"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeRepeatedStringField(value: &self.values) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    if !self.values.isEmpty {
      try visitor.visitRepeatedStringField(value: self.values, fieldNumber: 1)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_Strings, rhs: Spark_Connect_Strings) -> Bool {
    if lhs.values != rhs.values {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
