/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.regex.Pattern;
import org.apache.commons.fileupload2.core.RequestContext;

public abstract class AbstractRequestContext<T>
implements RequestContext {
    private static final Pattern MULTIPART_RELATED = Pattern.compile("^\\s*multipart/related.*", 2);
    private final LongSupplier contentLengthDefault;
    private final Function<String, String> contentLengthString;
    private final T request;

    protected AbstractRequestContext(Function<String, String> contentLengthString, LongSupplier contentLengthDefault, T request) {
        this.contentLengthString = Objects.requireNonNull(contentLengthString, "contentLengthString");
        this.contentLengthDefault = Objects.requireNonNull(contentLengthDefault, "contentLengthDefault");
        this.request = Objects.requireNonNull(request, "request");
    }

    @Override
    public long getContentLength() {
        try {
            return Long.parseLong(this.contentLengthString.apply("Content-length"));
        }
        catch (NumberFormatException e) {
            return this.contentLengthDefault.getAsLong();
        }
    }

    public T getRequest() {
        return this.request;
    }

    @Override
    public boolean isMultipartRelated() {
        return MULTIPART_RELATED.matcher(this.getContentType()).matches();
    }

    public String toString() {
        return String.format("%s [ContentLength=%s, ContentType=%s]", this.getClass().getSimpleName(), this.getContentLength(), this.getContentType());
    }
}

