/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import org.apache.commons.numbers.core.Sum;
import org.apache.commons.statistics.descriptive.LongMean;
import org.apache.commons.statistics.distribution.ChiSquaredDistribution;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.InferenceException;
import org.apache.commons.statistics.inference.SignificanceResult;
import org.apache.commons.statistics.inference.StatisticUtils;

public final class GTest {
    private static final GTest DEFAULT = new GTest(0);
    private final int degreesOfFreedomAdjustment;

    private GTest(int degreesOfFreedomAdjustment) {
        this.degreesOfFreedomAdjustment = degreesOfFreedomAdjustment;
    }

    public static GTest withDefaults() {
        return DEFAULT;
    }

    public GTest withDegreesOfFreedomAdjustment(int v) {
        return new GTest(Arguments.checkNonNegative(v));
    }

    public double statistic(long[] observed) {
        Arguments.checkValuesRequiredSize(observed.length, 2);
        Arguments.checkNonNegative(observed);
        double e = LongMean.of((long[])observed).getAsDouble();
        if (e == 0.0) {
            throw new InferenceException("No data");
        }
        Sum sum = Sum.create();
        Sum sum2 = Sum.create();
        long[] lArray = observed;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            double o = lArray[i];
            if (o > e) {
                sum.add(o * Math.log(o / e));
                continue;
            }
            if (!(o > 0.0)) continue;
            sum2.add(o * Math.log(o / e));
        }
        return sum.add(sum2).getAsDouble() * 2.0;
    }

    public double statistic(double[] expected, long[] observed) {
        double ratio = StatisticUtils.computeRatio(expected, observed);
        Sum sum = Sum.create();
        Sum sum2 = Sum.create();
        for (int i = 0; i < observed.length; ++i) {
            long o = observed[i];
            if (o == 0L) continue;
            double term = (double)o * Math.log((double)o / (ratio * expected[i]));
            if (term < 0.0) {
                sum2.add(term);
                continue;
            }
            sum.add(term);
        }
        return sum.add(sum2).getAsDouble() * 2.0;
    }

    public double statistic(long[][] counts) {
        Arguments.checkCategoriesRequiredSize(counts.length, 2);
        Arguments.checkValuesRequiredSize(counts[0].length, 2);
        Arguments.checkRectangular(counts);
        Arguments.checkNonNegative(counts);
        int ni = counts.length;
        int nj = counts[0].length;
        double[] sumi = new double[ni];
        double[] sumj = new double[nj];
        double n = 0.0;
        Sum sum = Sum.create();
        for (int i = 0; i < ni; ++i) {
            for (int j = 0; j < nj; ++j) {
                long c = counts[i][j];
                int n2 = i;
                sumi[n2] = sumi[n2] + (double)c;
                int n3 = j;
                sumj[n3] = sumj[n3] + (double)c;
                if (c <= 1L) continue;
                sum.add((double)c * Math.log(c));
            }
            GTest.checkNonZero(sumi[i], "Row", i);
            n += sumi[i];
        }
        for (int j = 0; j < nj; ++j) {
            GTest.checkNonZero(sumj[j], "Column", j);
        }
        sum.addProduct(n, Math.log(n));
        Sum sum2 = Sum.create();
        for (double c : sumi) {
            sum2.add(c * -Math.log(c));
        }
        for (double c : sumj) {
            sum2.add(c * -Math.log(c));
        }
        return sum.add(sum2).getAsDouble() * 2.0;
    }

    public SignificanceResult test(long[] observed) {
        int df = observed.length - 1;
        double g = this.statistic(observed);
        double p = GTest.computeP(g, df);
        return new BaseSignificanceResult(g, p);
    }

    public SignificanceResult test(double[] expected, long[] observed) {
        int df = StatisticUtils.computeDegreesOfFreedom(observed.length, this.degreesOfFreedomAdjustment);
        double g = this.statistic(expected, observed);
        double p = GTest.computeP(g, df);
        return new BaseSignificanceResult(g, p);
    }

    public SignificanceResult test(long[][] counts) {
        double g = this.statistic(counts);
        double df = ((double)counts.length - 1.0) * ((double)counts[0].length - 1.0);
        double p = GTest.computeP(g, df);
        return new BaseSignificanceResult(g, p);
    }

    private static double computeP(double g, double degreesOfFreedom) {
        return ChiSquaredDistribution.of((double)degreesOfFreedom).survivalProbability(g);
    }

    private static void checkNonZero(double value, String name, int index) {
        if (value == 0.0) {
            throw new InferenceException("%s[%s] is zero", name, index);
        }
    }
}

