/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.core.impl.scheduling.cron.quartz;

import org.apache.felix.hc.core.impl.scheduling.AsyncJob;
import org.apache.felix.hc.core.impl.scheduling.cron.quartz.QuartzCronSchedulerProvider;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQuartzCronJob
extends AsyncJob {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncQuartzCronJob.class);
    private static final String JOB_DATA_KEY_JOB = "asyncHcJob";
    private final String id;
    private final String group;
    private final String cronExpression;
    private final Scheduler quartzScheduler;
    private JobKey jobKey = null;

    public AsyncQuartzCronJob(Runnable runnable, QuartzCronSchedulerProvider quartzCronSchedulerProvider, String id, String group, String cronExpression) {
        super(runnable);
        this.quartzScheduler = quartzCronSchedulerProvider.getQuartzCronScheduler().getScheduler();
        this.id = id;
        this.group = group;
        this.cronExpression = cronExpression;
    }

    public JobKey getJobKey() {
        return this.jobKey;
    }

    private JobDetail getQuartzJobDetail() {
        JobDataMap jobData = new JobDataMap();
        jobData.put(JOB_DATA_KEY_JOB, (Object)this.runnable);
        JobDetail job = JobBuilder.newJob(QuartzJob.class).setJobData(jobData).withIdentity(this.id, this.group).build();
        this.jobKey = job.getKey();
        return job;
    }

    @Override
    public boolean schedule() {
        try {
            JobDetail job = this.getQuartzJobDetail();
            CronTrigger cronTrigger = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)this.cronExpression)).forJob(job).build();
            this.quartzScheduler.scheduleJob(job, (Trigger)cronTrigger);
            LOG.info("Scheduled job {} with trigger {}", (Object)job, (Object)cronTrigger);
            return true;
        }
        catch (SchedulerException e) {
            LOG.error("Could not schedule job for " + this.runnable + ": " + e, (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean unschedule() {
        LOG.debug("Unscheduling job {}", (Object)this.jobKey);
        try {
            this.quartzScheduler.deleteJob(this.jobKey);
            return true;
        }
        catch (SchedulerException e) {
            LOG.error("Could not unschedule job for " + this.jobKey + ": " + e, (Throwable)e);
            return false;
        }
    }

    public String toString() {
        return "[Async quartz job for " + this.runnable + "]";
    }

    public static class QuartzJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            Runnable ayncJob = (Runnable)context.getJobDetail().getJobDataMap().get((Object)AsyncQuartzCronJob.JOB_DATA_KEY_JOB);
            ayncJob.run();
        }
    }
}

