/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi.state;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.hierarchy.PropertyEntry;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.jcr2spi.nodetype.EffectiveNodeTypeProvider;
import org.apache.jackrabbit.jcr2spi.nodetype.ItemDefinitionProvider;
import org.apache.jackrabbit.jcr2spi.operation.AddNode;
import org.apache.jackrabbit.jcr2spi.operation.AddProperty;
import org.apache.jackrabbit.jcr2spi.operation.IgnoreOperation;
import org.apache.jackrabbit.jcr2spi.operation.Move;
import org.apache.jackrabbit.jcr2spi.operation.Operation;
import org.apache.jackrabbit.jcr2spi.operation.Remove;
import org.apache.jackrabbit.jcr2spi.operation.ReorderNodes;
import org.apache.jackrabbit.jcr2spi.operation.SetMixin;
import org.apache.jackrabbit.jcr2spi.operation.SetPrimaryType;
import org.apache.jackrabbit.jcr2spi.operation.SetPropertyValue;
import org.apache.jackrabbit.jcr2spi.operation.SetTree;
import org.apache.jackrabbit.jcr2spi.operation.TransientOperationVisitor;
import org.apache.jackrabbit.jcr2spi.state.ChangeLog;
import org.apache.jackrabbit.jcr2spi.state.ItemState;
import org.apache.jackrabbit.jcr2spi.state.ItemStateFactory;
import org.apache.jackrabbit.jcr2spi.state.ItemStateValidator;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.state.PropertyState;
import org.apache.jackrabbit.jcr2spi.state.TransientItemStateManager;
import org.apache.jackrabbit.jcr2spi.state.UpdatableItemStateManager;
import org.apache.jackrabbit.jcr2spi.util.ReferenceChangeTracker;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionItemStateManager
extends TransientOperationVisitor
implements UpdatableItemStateManager {
    private static Logger log = LoggerFactory.getLogger(SessionItemStateManager.class);
    private final UpdatableItemStateManager workspaceItemStateMgr;
    private final TransientItemStateManager transientStateMgr;
    private final ItemStateValidator validator;
    private final QValueFactory qValueFactory;
    private final SessionImpl mgrProvider;

    public SessionItemStateManager(UpdatableItemStateManager workspaceItemStateMgr, ItemStateValidator validator, QValueFactory qValueFactory, ItemStateFactory isf, SessionImpl mgrProvider) {
        this.workspaceItemStateMgr = workspaceItemStateMgr;
        this.transientStateMgr = new TransientItemStateManager();
        isf.addCreationListener(this.transientStateMgr);
        this.validator = validator;
        this.qValueFactory = qValueFactory;
        this.mgrProvider = mgrProvider;
    }

    public boolean hasPendingChanges() {
        return this.transientStateMgr.hasPendingChanges();
    }

    public void save(ItemState state) throws ReferentialIntegrityException, InvalidItemStateException, RepositoryException {
        if (!this.transientStateMgr.hasPendingChanges()) {
            return;
        }
        ChangeLog changeLog = this.transientStateMgr.getChangeLog(state, true);
        if (!changeLog.isEmpty()) {
            this.workspaceItemStateMgr.execute(changeLog);
            this.transientStateMgr.dispose(changeLog);
            changeLog.reset();
        }
    }

    public void undo(ItemState itemState) throws ConstraintViolationException, RepositoryException {
        if (!this.transientStateMgr.hasPendingChanges()) {
            return;
        }
        ChangeLog changeLog = this.transientStateMgr.getChangeLog(itemState, false);
        if (!changeLog.isEmpty()) {
            changeLog.undo();
            this.transientStateMgr.dispose(changeLog);
            changeLog.reset();
        }
    }

    public void adjustReferences(ReferenceChangeTracker refTracker) throws ConstraintViolationException, RepositoryException {
        Iterator<PropertyState> it = refTracker.getReferences();
        while (it.hasNext()) {
            PropertyState propState = it.next();
            boolean modified = false;
            QValue[] values = propState.getValues();
            QValue[] newVals = new QValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                QValue val = values[i];
                QValue adjusted = refTracker.getMappedReference(val, this.qValueFactory);
                if (adjusted != null) {
                    newVals[i] = adjusted;
                    modified = true;
                    continue;
                }
                newVals[i] = val;
            }
            if (!modified) continue;
            int options = 14;
            this.setPropertyStateValue(propState, newVals, 9, options);
        }
        refTracker.clear();
    }

    @Override
    public void execute(Operation operation) throws RepositoryException {
        operation.accept(this);
    }

    @Override
    public void execute(ChangeLog changes) throws RepositoryException {
        throw new UnsupportedOperationException("Not implemented for SessionItemStateManager");
    }

    @Override
    public void dispose() {
        this.transientStateMgr.dispose();
        this.workspaceItemStateMgr.dispose();
    }

    @Override
    public void visit(AddNode operation) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        NodeState parent = operation.getParentState();
        ItemDefinitionProvider defProvider = this.mgrProvider.getItemDefinitionProvider();
        QNodeDefinition def = defProvider.getQNodeDefinition(parent.getAllNodeTypeNames(), operation.getNodeName(), operation.getNodeTypeName());
        List<ItemState> newStates = this.addNodeState(parent, operation.getNodeName(), operation.getNodeTypeName(), operation.getUuid(), def, operation.getOptions());
        operation.addedState(newStates);
        if (!(operation instanceof IgnoreOperation)) {
            this.transientStateMgr.addOperation(operation);
        }
    }

    @Override
    public void visit(AddProperty operation) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        NodeState parent = operation.getParentState();
        Name propertyName = operation.getPropertyName();
        QPropertyDefinition pDef = operation.getDefinition();
        int targetType = pDef.getRequiredType();
        if (targetType == 0 && (targetType = operation.getPropertyType()) == 0) {
            targetType = 1;
        }
        this.addPropertyState(parent, propertyName, targetType, operation.getValues(), pDef, operation.getOptions());
        if (!(operation instanceof IgnoreOperation)) {
            this.transientStateMgr.addOperation(operation);
        }
    }

    @Override
    public void visit(SetTree operation) throws RepositoryException {
        this.transientStateMgr.addOperation(operation);
    }

    @Override
    public void visit(Move operation) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        NodeState srcState = operation.getSourceState();
        NodeState srcParent = operation.getSourceParentState();
        NodeState destParent = operation.getDestinationParentState();
        this.validator.checkRemoveItem(srcState, operation.getOptions());
        this.validator.checkAddNode(destParent, operation.getDestinationName(), srcState.getNodeTypeName(), operation.getOptions());
        ItemDefinitionProvider defProvider = this.mgrProvider.getItemDefinitionProvider();
        QNodeDefinition newDefinition = defProvider.getQNodeDefinition(destParent.getAllNodeTypeNames(), operation.getDestinationName(), srcState.getNodeTypeName());
        srcParent.moveChildNodeEntry(destParent, srcState, operation.getDestinationName(), newDefinition);
        this.transientStateMgr.addOperation(operation);
    }

    @Override
    public void visit(Remove operation) throws ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        ItemState state = operation.getRemoveState();
        this.removeItemState(state, operation.getOptions());
        this.transientStateMgr.addOperation(operation);
        operation.getParentState().markModified();
    }

    @Override
    public void visit(SetMixin operation) throws ConstraintViolationException, AccessDeniedException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        Name[] mixinNames = operation.getMixinNames();
        NodeState nState = operation.getNodeState();
        NodeEntry nEntry = nState.getNodeEntry();
        PropertyEntry mixinEntry = nEntry.getPropertyEntry(NameConstants.JCR_MIXINTYPES);
        if (mixinNames.length > 0) {
            if (mixinEntry != null) {
                PropertyState pState = mixinEntry.getPropertyState();
                this.setPropertyStateValue(pState, SessionItemStateManager.getQValues(mixinNames, this.qValueFactory), 7, operation.getOptions());
            } else {
                ItemDefinitionProvider defProvider = this.mgrProvider.getItemDefinitionProvider();
                QPropertyDefinition pd = defProvider.getQPropertyDefinition(nState.getAllNodeTypeNames(), NameConstants.JCR_MIXINTYPES, 7, true);
                QValue[] mixinValue = SessionItemStateManager.getQValues(mixinNames, this.qValueFactory);
                this.addPropertyState(nState, pd.getName(), pd.getRequiredType(), mixinValue, pd, operation.getOptions());
            }
            nState.markModified();
            this.transientStateMgr.addOperation(operation);
        } else if (mixinEntry != null) {
            PropertyState pState = mixinEntry.getPropertyState();
            this.removeItemState(pState, operation.getOptions());
            nState.markModified();
            this.transientStateMgr.addOperation(operation);
        }
    }

    @Override
    public void visit(SetPrimaryType operation) throws ConstraintViolationException, RepositoryException {
        Name primaryName = operation.getPrimaryTypeName();
        NodeState nState = operation.getNodeState();
        NodeEntry nEntry = nState.getNodeEntry();
        EffectiveNodeTypeProvider entProvider = this.mgrProvider.getEffectiveNodeTypeProvider();
        Name[] mixins = nState.getMixinTypeNames();
        ArrayList<Name> all = new ArrayList<Name>(Arrays.asList(mixins));
        all.add(primaryName);
        entProvider.getEffectiveNodeType(all.toArray(new Name[all.size()]));
        PropertyEntry pEntry = nEntry.getPropertyEntry(NameConstants.JCR_PRIMARYTYPE);
        PropertyState pState = pEntry.getPropertyState();
        this.setPropertyStateValue(pState, SessionItemStateManager.getQValues(new Name[]{primaryName}, this.qValueFactory), 7, operation.getOptions());
        nState.markModified();
        this.transientStateMgr.addOperation(operation);
    }

    @Override
    public void visit(SetPropertyValue operation) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        PropertyState pState = operation.getPropertyState();
        this.setPropertyStateValue(pState, operation.getValues(), operation.getValueType(), operation.getOptions());
        this.transientStateMgr.addOperation(operation);
    }

    @Override
    public void visit(ReorderNodes operation) throws ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        NodeState parent = operation.getParentState();
        parent.reorderChildNodeEntries(operation.getInsertNode(), operation.getBeforeNode());
        this.transientStateMgr.addOperation(operation);
    }

    private PropertyState addPropertyState(NodeState parent, Name propertyName, int propertyType, QValue[] values, QPropertyDefinition pDef, int options) throws LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, NoSuchNodeTypeException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        this.validator.checkAddProperty(parent, propertyName, pDef, options);
        return this.transientStateMgr.createNewPropertyState(propertyName, parent, pDef, values, propertyType);
    }

    private List<ItemState> addNodeState(NodeState parent, Name nodeName, Name nodeTypeName, String uuid, QNodeDefinition definition, int options) throws RepositoryException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchNodeTypeException, ItemExistsException, VersionException {
        this.validator.checkAddNode(parent, nodeName, nodeTypeName, options);
        EffectiveNodeType ent = this.mgrProvider.getEffectiveNodeTypeProvider().getEffectiveNodeType(nodeTypeName);
        if (nodeTypeName == null && (nodeTypeName = definition.getDefaultPrimaryType()) == null) {
            String msg = "No applicable node type could be determined for " + nodeName;
            log.debug(msg);
            throw new ConstraintViolationException(msg);
        }
        ArrayList<ItemState> addedStates = new ArrayList<ItemState>();
        NodeState nodeState = this.transientStateMgr.createNewNodeState(nodeName, null, nodeTypeName, definition, parent);
        addedStates.add(nodeState);
        if (uuid != null) {
            QValue[] value = SessionItemStateManager.getQValues(uuid, this.qValueFactory);
            ItemDefinitionProvider defProvider = this.mgrProvider.getItemDefinitionProvider();
            QPropertyDefinition pDef = defProvider.getQPropertyDefinition(NameConstants.MIX_REFERENCEABLE, NameConstants.JCR_UUID, 1, false);
            addedStates.add(this.addPropertyState(nodeState, NameConstants.JCR_UUID, 1, value, pDef, 0));
        }
        for (QPropertyDefinition qPropertyDefinition : ent.getAutoCreateQPropertyDefinitions()) {
            QValue[] autoValue;
            if (nodeState.hasPropertyName(qPropertyDefinition.getName()) || (autoValue = this.computeSystemGeneratedPropertyValues(nodeState, qPropertyDefinition)) == null) continue;
            int propOptions = 0;
            addedStates.add(this.addPropertyState(nodeState, qPropertyDefinition.getName(), qPropertyDefinition.getRequiredType(), autoValue, qPropertyDefinition, propOptions));
        }
        for (QItemDefinition qItemDefinition : ent.getAutoCreateQNodeDefinitions()) {
            int opt = 34;
            addedStates.addAll(this.addNodeState(nodeState, qItemDefinition.getName(), qItemDefinition.getDefaultPrimaryType(), null, (QNodeDefinition)qItemDefinition, opt));
        }
        return addedStates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeItemState(ItemState itemState, int options) throws RepositoryException {
        this.validator.checkRemoveItem(itemState, options);
        boolean success = false;
        try {
            itemState.getHierarchyEntry().transientRemove();
            success = true;
        }
        finally {
            if (!success) {
                // empty if block
            }
        }
    }

    private void setPropertyStateValue(PropertyState propState, QValue[] iva, int valueType, int options) throws ValueFormatException, LockException, ConstraintViolationException, AccessDeniedException, ItemExistsException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        this.validator.checkSetProperty(propState, options);
        propState.setValues(iva, valueType);
    }

    private QValue[] computeSystemGeneratedPropertyValues(NodeState parent, QPropertyDefinition def) throws RepositoryException {
        QValue[] genValues = null;
        QValue[] qDefaultValues = def.getDefaultValues();
        if (qDefaultValues != null && qDefaultValues.length > 0) {
            genValues = qDefaultValues;
        } else if (def.isAutoCreated()) {
            Name declaringNT = def.getDeclaringNodeType();
            Name name = def.getName();
            if (NameConstants.JCR_PRIMARYTYPE.equals(name)) {
                genValues = new QValue[]{this.qValueFactory.create(parent.getNodeTypeName())};
            } else if (NameConstants.JCR_MIXINTYPES.equals(name)) {
                Name[] mixins = parent.getMixinTypeNames();
                genValues = SessionItemStateManager.getQValues(mixins, this.qValueFactory);
            } else {
                genValues = NameConstants.JCR_CREATED.equals(name) && (NameConstants.MIX_CREATED.equals(declaringNT) || NameConstants.NT_HIERARCHYNODE.equals(declaringNT)) ? new QValue[]{this.qValueFactory.create(Calendar.getInstance())} : (NameConstants.JCR_CREATEDBY.equals(name) && NameConstants.MIX_CREATED.equals(declaringNT) ? new QValue[]{this.qValueFactory.create(this.mgrProvider.getUserID(), 1)} : (NameConstants.JCR_LASTMODIFIED.equals(name) && NameConstants.MIX_LASTMODIFIED.equals(declaringNT) ? new QValue[]{this.qValueFactory.create(Calendar.getInstance())} : (NameConstants.JCR_LASTMODIFIEDBY.equals(name) && NameConstants.MIX_LASTMODIFIED.equals(declaringNT) ? new QValue[]{this.qValueFactory.create(this.mgrProvider.getUserID(), 1)} : this.qValueFactory.computeAutoValues(def))));
            }
        }
        return genValues;
    }

    private static QValue[] getQValues(Name[] qNames, QValueFactory factory) throws RepositoryException {
        QValue[] ret = new QValue[qNames.length];
        for (int i = 0; i < qNames.length; ++i) {
            ret[i] = factory.create(qNames[i]);
        }
        return ret;
    }

    private static QValue[] getQValues(String uniqueID, QValueFactory factory) throws RepositoryException {
        return new QValue[]{factory.create(uniqueID, 1)};
    }
}

