# AGENTS.md - mx-service-manager

## Build Commands
- Build: `make` or `make release` (Qt6 qmake-based build system)
- Debug build: `make debug`
- Clean: `make clean` or `make distclean`
- Regenerate Makefile: `qmake6 mx-service-manager.pro`

## Code Style Guidelines
- C++20 standard with Qt6 framework
- Use `#pragma once` for header guards
- Copyright headers required in all files (see existing files for format)
- Include order: Qt headers, local headers, then std headers
- Member variables use camelCase, no prefixes
- Private members listed after public/protected sections
- Use `[[nodiscard]]` for functions returning values that shouldn't be ignored
- Use `Q_DISABLE_COPY` for classes that shouldn't be copied
- Smart pointers: `QSharedPointer<>` for Qt objects
- Initialization: prefer member initializer lists and default values
- Use `explicit` for single-argument constructors
- Qt slots/signals naming: use underscore_case for slot functions
- Error handling: return bool for success/failure operations
- String handling: prefer `QString` over `std::string`
- Use `qEnvironmentVariable()` for environment access
- Constants: use `const` or `inline const` for compile-time constants